
<?php $__env->startSection('title'); ?>
    Admin | Sub Category
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

    <style type="text/css">

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Add Sub Category</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="<?php echo e(route('sub_category.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="name">Category <span class="text-danger">*</span></label>
                                        <select class="form-control select2-single" name="category_id" required style="width: 100%">
                                            <option selected disabled value="">--Select category--</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <span class="text-danger"><?php echo e($errors->has('category_id') ? $errors->first('category_id'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label  for="name">Name <span class="text-danger">*</span></label>
                                  
                                        <input class=" form-control" name="name" placeholder="Name" type="text"
                                               autocomplete="off" required>
                                        <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                                   
                                </div>
                                <div class="form-group ">
                                    <label for="slug">Slug <span class="text-danger"></span></label>
                                   
                                        <input class=" form-control" name="slug" placeholder="Slug" type="text" autocomplete="off">
                                        <span class="text-danger"><?php echo e($errors->has('slug') ? $errors->first('slug'):''); ?></span>
                                    
                                </div>

                                <div class="form-group ">
                                    <label for="possition">Position <span class="text-danger"></span></label>
                                        <input class="form-control" id="position" min="0" type="number" name="position" placeholder="Position">
                                        <span class="text-danger"><?php echo e($errors->has('position') ? $errors->first('position'):''); ?></span>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-5-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Sub Category</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Category</th>
                                        <th>Name</th>
                                        <th class="text-center">Position</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $items = \App\Models\SubCategory::orderBy('category_id','asc')->orderBy('position','asc')->Paginate(30); ?>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($row->id); ?></td>
                                            <td><?php echo e($row->category->name); ?></td>
                                            <td><?php echo e($row->name); ?></td>
                                            <td class="text-center"><?php echo e($row->position); ?></td>
                                            <td class="col__action__body">
                                                <a title="view" target="_blank" href="<?php echo e(url('/').'/'.$row->parentCategory->slug.'/'.$row->category->slug.'/'.$row->slug); ?>"
                                                   class="btn btn-success btn-sm">View</a>
                                                            
                                                <a title="edit" href="<?php echo e(route('sub_category.edit', ['id' => $row->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>

                                                <div style="display: inline-block;">
                                                    <form method="POST"
                                                          action="<?php echo e(route('sub_category.destroy', ['id' => $row->id])); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input name="_method" type="hidden" value="DELETE">
                                                        <button type="submit"
                                                                class="btn btn-danger btn-sm delete_confirm"
                                                                data-toggle="tooltip" title='Delete'>Delete</button>
                                                    </form>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                                <div class="pagination px-3 pb-2">
                                    <?php echo e($items->links()); ?>

                                </div>
                            </div>
                    </div>
                </div> <!--col-6-->
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/back/sub_category/sub_category_create.blade.php ENDPATH**/ ?>