<?php $__env->startSection('meta_info'); ?>
    <title><?php echo e($post->headline); ?></title>
    <meta name="keywords" content="<?php echo e(setting('meta_kayword')); ?>"/>
    <meta name="description" content="<?php echo e($post->intro); ?>"/>
    <meta itemscope itemtype="<?php echo e(news_url($post->id)); ?>"/>
    <meta property="og:title" content="<?php echo e($post->headline); ?> | <?php echo e(setting('site_title')); ?>"/>
    <meta property="og:description" content="<?php echo e($post->intro); ?>">
    <meta property="og:image" content="<?php echo e(asset($post->image)); ?>">
    <meta property="og:image:width" content="640"/>
    <meta property="og:image:height" content="360"/>
    <meta property="og:url" content="<?php echo e(news_url($post->id)); ?>">
    <meta property="og:image:type" content="image/jpeg"/>
    <meta property="og:image:alt" content="<?php echo e($post->headline); ?>">
    <meta property="og:type" content="website">
    <meta name="twitter:url" content="<?php echo e(news_url($post->id)); ?>"/>
    <meta name="twitter:title" content="<?php echo e($post->headline); ?> | <?php echo e(setting('site_title')); ?>"/>
    <meta name="twitter:description" content="<?php echo e($post->intro); ?>"/>
    <meta name="twitter:image" content="<?php echo e(asset($post->image)); ?>"/>
    <meta property="ia:markup_url" content="<?php echo e(news_url($post->id)); ?>"/>
    <meta property="ia:markup_url_dev" content="<?php echo e(news_url($post->id)); ?>"/>
    <meta property="ia:rules_url" content="<?php echo e(news_url($post->id)); ?>"/>
    <meta property="ia:rules_url_dev" content="<?php echo e(news_url($post->id)); ?>"/>
    <link rel="canonical" href="<?php echo e(news_url($post->id)); ?>"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



    <section class="mt-4 pt-lg-2 pb-3">
        <div class="container">
            <div class="row pt-2 pt-md-3">
                <div class="col-lg-10 m-auto">
                    <h1 class="pb-3" style="max-width: 970px;"><?php echo e($post->headline ?? ''); ?></h1>
                    <div class="d-flex flex-md-row flex-column align-items-md-center justify-content-md-between mb-3">
                        <div class="d-flex align-items-center flex-wrap text-muted mb-md-0 mb-4">
                            <div class="fs-xs border-end pe-3 me-3 mb-2">
                                <span class="badge bg-faded-primary text-primary fs-base">Blog</span>
                            </div>
                            <div class="fs-sm pe-3 me-3 mb-2"><?php echo e(view_date_format($post->created_at,'l, F d, Y')); ?></div>
                        </div>
                        <div class="d-flex align-items-center position-relative">
                            <a href="#" class="btn btn-icon btn-secondary btn-linkedin me-2 mb-2" aria-label="LinkedIn">
                                <i class="bx bxl-linkedin"></i>
                            </a>
                            <a href="#" class="btn btn-icon btn-secondary btn-facebook me-2 mb-2" aria-label="Facebook">
                                <i class="bx bxl-facebook"></i>
                            </a>
                            <a href="#" class="btn btn-icon btn-secondary btn-twitter me-2 mb-2" aria-label="Twitter">
                                <i class="bx bxl-twitter"></i>
                            </a>
                            <a href="#" class="btn btn-icon btn-secondary btn-instagram me-2 mb-2"
                               aria-label="Instagram">
                                <i class="bx bxl-instagram"></i>
                            </a>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
        <div class="container pb-4">
            <div class="row">
                <div class="col-lg-10 m-auto py-4">
                    <div class="text-center">
                        <img src="<?php echo e(asset($post->image)); ?>" alt="<?php echo e($post->headline ?? ''); ?>" class="img-fluid rounded w-100">
                    </div>
                </div>
                <div class="col-lg-10 m-auto">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="content__body">
                                <?php echo $post->content ?? ''; ?>

                            </div>
                        </div>
                        <div class="col-lg-4 position-relative">
                            <div class="sticky-top ms-xl-5 ms-lg-4 ps-xxl-4" style="top: 105px !important;">
                                <h6>Share this post:</h6>
                                <div class="mb-4 pb-lg-3">
                                    <a href="#" class="btn btn-icon btn-secondary btn-linkedin me-2 mb-2"
                                       aria-label="LinkedIn">
                                        <i class="bx bxl-linkedin"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-facebook me-2 mb-2"
                                       aria-label="Facebook">
                                        <i class="bx bxl-facebook"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-twitter me-2 mb-2"
                                       aria-label="Twitter">
                                        <i class="bx bxl-twitter"></i>
                                    </a>
                                    <a href="#" class="btn btn-icon btn-secondary btn-instagram me-2 mb-2"
                                       aria-label="Instagram">
                                        <i class="bx bxl-instagram"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/front/pages/single_post.blade.php ENDPATH**/ ?>