
<?php $__env->startSection('title'); ?>
    Admin | Ads settings
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
        <div class="container-fluid">
            <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Add Advertisement</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="<?php echo e(route('ad.store')); ?>"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                        <input class=" form-control" name="name" placeholder="Name" type="text"
                                               autocomplete="off" required>
                                        <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="url">URL <span class="text-danger"></span></label>
                                        <input class=" form-control" name="url" placeholder="URL" type="text">
                                        <span class="text-danger"><?php echo e($errors->has('url') ? $errors->first('url'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="position">Position <span
                                                class="text-danger"></span></label>
                                        <input class=" form-control" name="position" placeholder="Position"
                                               type="number">
                                        <span class="text-danger"><?php echo e($errors->has('position') ? $errors->first('position'):''); ?></span>
                                </div>
                                <div class="form-group">
                                     <label class="mb-1">Photo <span class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="photo" name="photo">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger"><?php echo e($errors->has('photo') ? $errors->first('photo'):''); ?></span>
                                     <div class="pt-1" id="profileLabel" for="photo">
                                        <img class="profileImgShow" src="<?php echo e(asset('defaults/default3.png')); ?>">
                                     </div>
                                </div>
                                
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Advertisement</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th>URL</th>
                                        <th class="text-center col__pos">Position</th>
                                        <th>Photo</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <?php $__currentLoopData = \App\Models\Ad::orderBy('position','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($row->id); ?></td>
                                            <td><?php echo e($row->name); ?></td>
                                            <td><?php echo e($row->url); ?></td>
                                            <td class="text-center"><?php echo e($row->position); ?></td>
                                            <td><img src="<?php echo e(asset('/ads/'.$row->photo)); ?>" width="80px"></td>
                                            <td class="col__action__body">
                                                <a href="<?php echo e(route('ad.edit', ['id' => $row->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="<?php echo e(route('ad.delete', ['id' => $row->id])); ?>"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div> <!--col-6-->
            </div>
        </div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/back/ad/ad_index.blade.php ENDPATH**/ ?>