
<?php $__env->startSection('title'); ?>
    Admin | Popup ads setting
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
   
        <div class="container-fluid">
            <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Add Popup Adv.</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="<?php echo e(route('popup.store')); ?>"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                        <input class="form-control" name="name" placeholder="Name" type="text"
                                               autocomplete="off" maxlength="95" required>
                                        <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="link">Link <span class="text-danger"></span></label>
                                        <input class="form-control" name="link" placeholder="Link" type="text"
                                               autocomplete="off">
                                        <span class="text-danger"><?php echo e($errors->has('link') ? $errors->first('link'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="position">Visible for</label>
                                        <select name="position" id="position" class="form-control">
                                            <option value="home">Home Page</option>
                                            <option value="single">Single Page</option>
                                        </select>
                                        <span class="text-danger"><?php echo e($errors->has('position') ? $errors->first('position'):''); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="status">Status</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                        <span class="text-danger"><?php echo e($errors->has('status') ? $errors->first('status'):''); ?></span>
                                </div>

                                <div class="form-group">
                                     <label for="image">Image<small>(740x740)</small><span
                                                class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="image" name="image">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger"><?php echo e($errors->has('image') ? $errors->first('image'):''); ?></span>
                                     <div class="pt-1" id="profileLabel" for="image">
                                        <img class="profileImgShow" src="<?php echo e(asset('defaults/default3.png')); ?>">
                                     </div>
                                </div>
                                
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Popup Adv.</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center">Name</th>
                                        <th class="text-center">Visible for</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Image</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = App\Models\Popup::orderBy('id','desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($row->name); ?></td>
                                            <td class="text-center"><?php echo e($row->position); ?></td>
                                            <td class="text-center"><?php echo e($row->status ?'active':'inactive'); ?></td>
                                            <td class="text-center"><img width="100px"
                                                                         src="<?php echo e(asset('img/popup/'.$row->image)); ?>" class="float-none">
                                            </td>
                                            <td class="text-center col__action__body">
                                                <a href="<?php echo e(route('popup.edit', ['id' => $row->id])); ?>"
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="<?php echo e(route('popup.destroy', ['id' => $row->id])); ?>"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/back/popup/create.blade.php ENDPATH**/ ?>