
<?php $__env->startSection('title'); ?>
    Admin | Photos
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-10 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="pg__name float-left">
                                <h4 class=" font-weight-light my-2 float-left">
                                    All Photos
                                </h4>
                            </div>
                            <div class="pg__btn float-right">
                                <a href="<?php echo e(route('photo.create')); ?>" class="btn btn-primary">Add New</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Headline</th>
                                        <th class="text-center">Thumbnail</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center" width="70px"><?php echo e($photo->id); ?></td>
                                            <td class="post__name">
                                                <?php echo e(Str::limit($photo->title, 55)); ?>

                                            </td>
                                            <td class="text-center" style="width: 130px">
                                                <img src="<?php echo e($photo->featured_image); ?>" style="height: 60px; width: 80px; object-fit: cover">
                                            </td>
                                            <td class="col__action__body">
                                                <a title="edit" href="<?php echo e(route('photo.edit', ['id' => $photo->id])); ?>"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <div style="display: inline-block;">
                                                    <form method="POST"
                                                          action="<?php echo e(route('photo.destroy', ['id' => $photo->id])); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input name="_method" type="hidden" value="DELETE">
                                                        <button type="submit"
                                                                class="btn btn-danger btn-sm delete_confirm"
                                                                data-toggle="tooltip" title='Delete'>Delete</button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>

                                <?php echo e($photos->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hotelier/public_html/resources/views/back/photo/photo_index.blade.php ENDPATH**/ ?>