<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    @yield('meta_info')
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('settings/'. setting('favicon')) }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('settings/'. setting('favicon')) }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('settings/'. setting('favicon')) }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="{{ asset('assets/js/theme-switcher.js') }}"></script>
    <meta name="theme-color" content="#ffffff">
    <link rel="stylesheet" media="screen" href="{{ asset('assets/vendor/swiper/swiper-bundle.min.css') }}">
    <link rel="stylesheet" media="screen" href="{{ asset('assets/vendor/boxicons/css/boxicons.min.css') }}">
    <link rel="stylesheet" media="screen" href="{{ asset('assets/vendor/lightgallery/css/lightgallery-bundle.min.css') }}">
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/theme.min.css') }}">
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/layout.css') }}">
    
    <!-- Page loading scripts -->
    <script>
        (function () {
            window.onload = function () {
                const preloader = document.querySelector('.page-loading');
                preloader.classList.remove('active');
                setTimeout(function () {
                    preloader.remove();
                }, 1000);
            };
        })();
    </script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P5PHDTZEE7"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-P5PHDTZEE7');
    </script>

    <link rel="stylesheet" href="{{ asset('assets/css/layout.css') }}">
    @yield('css')
    <style>
        input[type=number]::-webkit-inner-spin-button, 
        input[type=number]::-webkit-outer-spin-button { 
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            margin: 0; 
        }
        .invalid-feedback{
            display: block !important;
        }
        input.field-invalid {
            border-color: var(--si-form-invalid-border-color) !important;
            padding-right: calc(1.6em + 1.25rem) !important;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23ef4444'%3e%3cpath d='M7.643 13.535L10 11.178l2.357 2.357 1.178-1.178L11.178 10l2.357-2.357-1.178-1.178L10 8.822 7.643 6.465 6.465 7.643 8.822 10l-2.357 2.357 1.178 1.178zM10 18.333c4.595 0 8.333-3.738 8.333-8.333S14.595 1.667 10 1.667 1.667 5.405 1.667 10 5.405 18.333 10 18.333zm0-15c3.676 0 6.667 2.991 6.667 6.667S13.676 16.667 10 16.667 3.333 13.676 3.333 10 6.324 3.333 10 3.333z'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(0.4em + 0.3125rem) center !important;
            background-size: calc(0.8em + 0.625rem) calc(0.8em + 0.625rem) !important;
        }
    </style>
</head>
<body>
<div class="page-loading active">
    <div class="page-loading-inner">
        <div class="page-spinner"></div>
        <span>Loading...</span>
    </div>
</div>
<main class="page-wrapper">
    @include('front.partial.header')
    @yield('content')
    @include('front.partial.footer')
</main>
<!-- Back to top button -->
<a href="#top" class="btn-scroll-top" data-scroll>
    <span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span>
    <i class="btn-scroll-top-icon bx bx-chevron-up"></i>
</a>
<!-- Vendor Scripts -->
<script src="{{ asset('assets/vendor/jarallax/dist/jarallax.min.js') }}"></script>

<script src="{{ asset('assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
<script src="{{ asset('assets/vendor/lightgallery/lightgallery.min.js') }}"></script>
<script src="{{ asset('assets/vendor/cleave.js/dist/cleave.min.js') }}"></script>

<script src="{{ asset('assets/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js') }}"></script>
<script src="{{ asset('assets/vendor/lightgallery/plugins/zoom/lg-zoom.min.js') }}"></script>
<script src="{{ asset('assets/vendor/lightgallery/plugins/video/lg-video.min.js') }}"></script>
<script src="{{ asset('assets/vendor/lightgallery/plugins/thumbnail/lg-thumbnail.min.js') }}"></script>

<!-- Main Theme Script -->
<script src="{{ asset('assets/js/theme.min.js') }}"></script>

<script>
    function formatPhoneNum(input) {
        let value = input.value.replace(/\D/g, '');  // Remove non-numeric characters
        if (value.length > 5) {
            value = value.slice(0, 5) + '-' + value.slice(5, 11);  // Insert hyphen after 5 digits
        }
        input.value = value;
    }
    const numberInputs = document.querySelectorAll('input[type="number"]');
    if (numberInputs) {
        numberInputs.forEach(function(input) {
        input.addEventListener("keyup", function() {
                this.value = this.value.replace(/[^0-9]/g, ""); // Remove any non-numeric characters
            });
        });
    } else {
        console.log('Number Field not found!');
    }
</script>
@yield('js')
</body>
</html>