@extends('layouts.frontend')
@section('meta_info')
    <title>{{ $post->headline }}</title>
    <meta name="keywords" content="{{ setting('meta_kayword') }}"/>
    <meta name="description" content="{{$post->intro}}"/>
    <meta itemscope itemtype="{{ news_url($post->id) }}"/>
    <meta property="og:title" content="{{ $post->headline }} | {{ setting('site_title') }}"/>
    <meta property="og:description" content="{{$post->intro}}">
    <meta property="og:image" content="{{ asset($post->image)}}">
    <meta property="og:image:width" content="640"/>
    <meta property="og:image:height" content="360"/>
    <meta property="og:url" content="{{ news_url($post->id) }}">
    <meta property="og:image:type" content="image/jpeg"/>
    <meta property="og:image:alt" content="{{$post->headline}}">
    <meta property="og:type" content="website">
    <meta name="twitter:url" content="{{ news_url($post->id) }}"/>
    <meta name="twitter:title" content="{{ $post->headline }} | {{ setting('site_title') }}"/>
    <meta name="twitter:description" content="{{$post->intro}}"/>
    <meta name="twitter:image" content="{{ asset($post->image)}}"/>
    <meta property="ia:markup_url" content="{{ news_url($post->id) }}"/>
    <meta property="ia:markup_url_dev" content="{{ news_url($post->id) }}"/>
    <meta property="ia:rules_url" content="{{ news_url($post->id) }}"/>
    <meta property="ia:rules_url_dev" content="{{ news_url($post->id) }}"/>
    <link rel="canonical" href="{{ news_url($post->id) }}"/>
@endsection
@section('content')
<section class="container pb-5 mb-md-2 mb-lg-4">
    <h1 class="border-bottom pb-4">{{$post->headline ?? ''}}</h1>
    {{--<h1 class="border-bottom pb-4">{{$category->name ?? '' }}</h1>--}}
    <div class="row pt-2 pt-md-3">
        <div class="col-md-10">
            <div class="text-center">
                <img src="{{ asset($post->image)}}" alt="{{$post->headline ?? ''}}">
            </div>
        </div>
        <div class="col-md-12">
            {!! $post->content ?? '' !!}
        </div>
    </div>
</section>
@endsection