@extends('layouts.backend')
@section('title')
    Admin | create page
@endsection

@section('extra_css')

    <style type="text/css">

    </style>
@endsection

@section('extra_js')

@endsection

@section('content')

    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Add New Page</h6>
                    </div>
                    <div class="card-body">
                        <form role="form" method="post" action="{{ route('page.store') }}"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="pagecategory_id " class="col-form-label text-md-right">Category <span
                                            class="text-danger">*</span></label>
                                <select name="pagecategory_id" id="pagecategory_id"
                                        class="form-control select2 @error('pagecategory_id')  is-invalid @enderror"
                                        required>
                                    <option value="">--Select Category--</option>
                                    @foreach($pagecategory as $cat)
                                        <option value="{{$cat->id}}">{{$cat->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="" for="title">Title <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="title" placeholder="Title" type="text"
                                           maxlength="200" required>
                                    <span class="text-danger">{{ $errors->has('title') ? $errors->first('title'):''}}</span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="mb-1" for="photo">Photo <span class="text-danger">*</span></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input profile-img-input" id="photo"
                                           name="photo" required>
                                    <label class="custom-file-label" for="customFile">Choose file</label>
                                </div>
                                <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                                <div class="pt-1" id="profileLabel" for="photo">
                                    <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12"><label class="" for="content">Content <span
                                                class="text-danger">*</span></label>
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                                    <textarea class="content" id="content24" name="content" rows="16">  </textarea>


                                    <script>
                                        var editor_config = {
                                            path_absolute: "/",
                                            selector: "#content24",
                                            plugins: [
                                                "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                                "searchreplace wordcount visualblocks visualchars code fullscreen",
                                                "insertdatetime media nonbreaking save table directionality",
                                                "emoticons template paste textcolor colorpicker textpattern"
                                            ],
                                            toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                            relative_urls: false,
                                            file_browser_callback: function (field_name, url, type, win) {
                                                var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                                var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                                var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                                if (type == 'image') {
                                                    cmsURL = cmsURL + "&type=Images";
                                                } else {
                                                    cmsURL = cmsURL + "&type=Files";
                                                }

                                                tinyMCE.activeEditor.windowManager.open({
                                                    file: cmsURL,
                                                    title: 'Filemanager',
                                                    width: x * 0.8,
                                                    height: y * 0.8,
                                                    resizable: "yes",
                                                    close_previous: "no"
                                                });
                                            }
                                        };
                                        tinymce.init(editor_config);
                                    </script>
                                    <span class="text-danger">{{ $errors->has('content') ? $errors->first('content'):''}}</span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="status" class="col-form-label text-md-right">Status</label>
                                <select name="status" id="status"
                                        class="form-control @error('status') is-invalid @enderror" required>
                                    <option value="1">Active</option>
                                    <option value="0">In-Active</option>
                                </select>
                            </div>
                            <button type="submit" class="float-right btn btn-primary">Create</button>
                        </form>
                    </div>
                </div>
            </div> <!--col-5-->
        </div>
    </div>

@endsection

