@extends('layouts.backend')
@section('title')
    Admin | All Data
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">All Client</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('client.create') }}" class="btn btn-primary float-right">Add New</a>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Name</th>
                                <th>Web Address</th>
                                <th class="text-center">Logo</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td class="text-center">{{$item->position}}</td>
                                    <td>{{$item->name}}</td>
                                    <td>{{$item->web_address}}</td>
                                    <td class="text-center">
                                        <img class="profileImgShow" src="{{ asset('img/client/'.$item->logo) }}" height="50px">
                                    </td>
                                    <td class="col__action__body">
                                        <a href="{{ route('client.edit', ['id' => $item->id])}}"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <a href="{{ route('client.destroy', ['id' => $item->id])}}"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-danger btn-sm">Delete</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
    </div>
</div>
    
@endsection
