<?php

namespace App\Providers;


use App\Services\Sms\Providers\MuthobartaSmsProvider;
use App\Services\Sms\Providers\SolversSmsProvider;
use App\Services\Sms\SmsService;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SmsService::class, function () {
            return new SmsService(new MuthobartaSmsProvider(), new SolversSmsProvider());
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
