<?php

namespace App\Models;

use App\Models\Event;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PaymentInfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_token',
        'first_name',
        'last_name',
        'email',
        'phone',
        'hotel_name',
        'payment_info',
        'amount',
        'order_id',
        'event_id',
        'shurjopay_id',
        'currency',
        'payable_amount',
        'discsount_amount',
        'disc_percent',
        'received_amount',
        'usd_amt',
        'usd_rate',
        'is_verify',
        'card_holder_name',
        'card_number',
        'bank_trx_id',
        'invoice_no',
        'bank_status',
        'customer_order_id',
        'sp_code',
        'sp_message',
        'name',
        'address',
        'city',
        'transaction_status',
        'method',
        'date_time',
    ];


    public function event(){
        return $this->belongsTo(Event::class,'event_id','id');
    }

}
