<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


use App\Models\ParentCategory;
use App\Models\Product;

class Category extends Model
{
    use HasFactory;
    
protected $fillable = ['parent_category_id','name','slug', 'position','shop_type','banner','icon','meta_title','meta_description'];
protected $table = 'categories';
    public function parentCategory()
    {
        return $this->belongsTo(ParentCategory::class);
    }

    public function subCategory()
    {
        return $this->hasMany(SubCategory::class, 'category_id');
    }

    public function posts()
    {
        return $this->belongsToMany(Post::class);
    }
}
