<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;

use DateTime;
use Auth;
use Image;

use File;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $slider = Slider::orderby('position','desc')->get();
        return view('back.slider.slider_index', compact('slider'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'device' => 'required',
            'image' => 'required',
            'image.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $slider =  new Slider();
        $slider->author  = Auth::user()->id;
        $slider->title    = $request->title;
        $slider->caption    = $request->caption;
        $slider->link    = $request->link;
        $slider->device    = $request->device;
        if($request->position == null){
            $id = Slider::orderby('position','desc')->first();
            if($id == null){
                $slider->position = 1;
            }else{
                $slider->position = $id->position+1;
            }
        }else{
            $slider->position = $request->position;
        }

        // if($request->hasfile('image')){
        //     $file = $request->file('image');
        //     $fileName = $file->getClientOriginalName();
        //     // $img = Image::make($file->getRealPath());
        //     // $img->crop($request->w, $request->h, $request->x1, $request->y1);
        //     // $img->save(public_path('/profile/' .$fileName));
        //     $image_resize = Image::make($file->getRealPath());       
        //     $image_resize->crop(982, 500);
        //     $image_resize->save(public_path('/img/slider/' .$fileName));
        //     $slider->image = $fileName;
        // }

        // if($request->hasfile('image')){
        //     $file = $request->file('image');
        //     $fileName = $file->getClientOriginalName();
        //     $file->move(public_path('/img/slider/'), $fileName);
        //     $slider->image = $fileName;
        // }
        
        if($request->hasfile('image')){
            $date_time = date('YmdHis');
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = $date_time.'.'.$fileExt;
            $f_image = $fileName;
            $file->move(public_path('/img/slider/'), $fileName);
            $slider->image = $f_image;
        }
        $slider->save(); 
        return Redirect()->route('slider.index')->with('success','data save successfully');
    }

  

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {   
        $sliders = Slider::orderby('position','asc')->get();
        $slider = Slider::find($id);
        return view('back.slider.slider_edit', compact('sliders', 'slider'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request , $id)
    {
        $slider = Slider::find($id);


        $request->validate([
            'device' => 'required',
            'image.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $slider->author  = Auth::user()->id;
        $slider->title    = $request->title;
        $slider->caption    = $request->caption;
        $slider->link    = $request->link;
        $slider->device    = $request->device;
        if($request->position == null){
            $slider->position = $slider->id;
        }else{
            $slider->position = $request->position;
        }
        if($request->hasfile('image')){
            $date_time = date('YmdHis');
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = $date_time.'.'.$fileExt;
            $f_image = $fileName;
            $file->move(public_path('/img/slider/'), $fileName);
            $slider->image = $f_image;
        }
        $slider->save(); 
        return Redirect()->route('slider.index')->with('success','data update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $slider = Slider::find($id);
        $image_path         = public_path("/img/slider/").$slider->image;
        if(File::exists($image_path)) {
            File::delete($image_path);
        }
        $slider->delete(); 
        return Redirect()->route('slider.index')->with('success','Deleted successfully');
    }
}
