<?php

namespace App\Http\Controllers;

use App\Models\ParentCategory;
use Illuminate\Http\Request;
use Image;
use File;
use Illuminate\Support\Facades\Session;
class ParentCategoryController extends Controller
{
    public function index(){
        return view('back.Pcategory.create');
    }
    public function create(){
        return view('back.Pcategory.create');
    }

    public function store(Request $request){
        $request->validate([
            'name' => 'required|max:100',
        ]);
        $category = new ParentCategory();
        $category->name = $request->name;
        
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $id = ParentCategory::orderby('id','desc')->first();
            if($id == null){
                $category->position = 1;
            }else{
                $category->position = $id->position+1;
            }
        }else{
            $category->position = $request->position;
        }
        
        if($request->hasfile('image')){
            $date_time = date('YmdHis');
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileName = $date_time.'.'.$fileExt;
            $f_image = '/parent-category/'.$fileName;
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(300, 300);
            $image_resize->save(public_path('/parent-category/' .$fileName));
            $category->image = $f_image;
        }


        // if($request->hasfile('icon')){
        //     $file = $request->file('icon');
        //     $fileName = $file->getClientOriginalName();
        //      $file->move(public_path('/img/category-thumb/'), $fileName);
        //     $category->icon = $fileName;
        // }

        $category->save();
        return Redirect()->back()->with('success',  'inserted successfully');
    }
    public function edit( $id){
        $item = ParentCategory::find($id);
       return view('back.Pcategory.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ParentCategory  $parentCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:100',
        ]);
        $category = ParentCategory::findOrfail($id);
        $category->name = $request->name;
        
        if($request->slug == null){
            $category->slug = make_slug($request->name);
        }else{
            $category->slug = make_slug($request->slug);
        }
        
        if($request->position == null){
            $id = ParentCategory::orderby('id','desc')->first();
            if($id == null){
                $category->position = 1;
            }else{
                $category->position = $id->position+1;
            }
        }else{
            $category->position = $request->position;
        }
        
        if($request->hasfile('image')){
            $date_time = date('YmdHis');
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileName = $date_time.'.'.$fileExt;
            $f_image = '/parent-category/'.$fileName;
            $image_resize = Image::make($file->getRealPath());       
            $image_resize->resize(300, 300);
            $image_resize->save(public_path('/parent-category/' .$fileName));
            $category->image = $f_image;
        }
        $category->save();
        return Redirect()->route('Pcategory.create')->with('success',  'updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ParentCategory  $parentCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        // $total = ParentCategory::find($id)->posts()->count();
        $total = 2;
        if($total == 0){
            $category = ParentCategory::find($id);
            if(File::exists(public_path($category->image))){
                File::delete(public_path($category->image));
            }
            $category->delete();
            Session::flash('success', 'Category deleted successfully');
        } else {
            Session::flash('danger', 'Sorry, this record related some other tables');
        }
        return Redirect()->route('Pcategory.create');
    }
}
