@extends('layouts.backend')
@section('title')
    Admin
@endsection

@section('extra_css')
    <style type="text/css">
        .toggle-off.btn {
            padding-left: 0px;
        }
    </style>
@endsection

@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-10">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 class="font-weight-normal  my-1">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-award" width="28" height="28"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff4500" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <circle cx="12" cy="9" r="6"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(-30 12 9)"/>
                                            <polyline points="9 14.2 9 21 12 19 15 21 15 14.2"
                                                      transform="rotate(30 12 9)"/>
                                        </svg>
                                        All Staffs
                                    </h4>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ route('staffs.create') }}" class="btn btn-primary float-right">Add New Staff</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Role</th>
                                        <th>Photo</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($staffs as $staff)
                                        <tr>
                                            <td>{{$staff->id}}</td>
                                            <td>{{$staff->name}}</td>
                                            <td>{{$staff->role}}</td>
                                            <td>
                                                <img width="100px"
                                                     src="{{ $staff->photo ? asset('profile/'.$staff->photo) : asset('defaults/avatar01.png')  }}">
                                            </td>
                                            <td>

                                                <input data-id="{{$staff->id}}" class="toggle-class" type="checkbox"
                                                       data-onstyle="success" data-offstyle="danger"
                                                       data-toggle="toggle" data-on="On"
                                                       data-off="Off" {{ $staff->status ? 'checked' : '' }}>

                                            </td>

                                            <td class="text-center">
                                                <a href="{{ route('staff.edit', ['id' => $staff->id])}}"
                                                   class="btn btn-success btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('staff.destroy', ['id' => $staff->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>

@endsection

@section('extra_js')

    <script>
        $(document).ready(function () {

            $('.toggle-class').change(function () {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');

                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{ route('changeStatus') }}",
                    data: {'status': status, 'id': id},
                    success: function (data) {
                        console.log('success')
                    }
                });
            })

        })
    </script>


@endsection

