@extends('layouts.backend')
@section('title')
    Admin | Customer list
@endsection

@section('extra_css')
    <style type="text/css">
        .toggle-off.btn {
            padding-left: 0px;
        }
    </style>
@endsection


@section('content')
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-10 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="float-left">
                                <h4 class="my-2 d-flex align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="38" height="38"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M5.931 6.936l1.275 4.249m5.607 5.609l4.251 1.275"/>
                                        <path d="M11.683 12.317l5.759 -5.759"/>
                                        <circle cx="5.5" cy="5.5" r="1.5"/>
                                        <circle cx="18.5" cy="5.5" r="1.5"/>
                                        <circle cx="18.5" cy="18.5" r="1.5"/>
                                        <circle cx="8.5" cy="15.5" r="4.5"/>
                                    </svg>
                                    All Customers
                                </h4>
                            </div>
                            <div class="float-right">
                                <a href="{{ route('customer.list.download.by.excel')}}"
                                   class="list-group-item list-group-item-action active" aria-current="true">Export</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th class="text-center">Mobile No</th>
                                        <th class="text-center">Role</th>
                                        <th class="text-center">Photo</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center" style="width: 170px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($customers as $customer)
                                        <tr>
                                            <td class="text-center">{{$customer->id}}</td>
                                            <td>{{$customer->name}}</td>
                                            <td class="text-center">{{$customer->phone}}</td>
                                            <td class="text-center">{{$customer->role}}</td>
                                            <td class="text-center">
                                                <img class="feature_image" src="{{ $customer->photo ? asset('profile/'.$customer->photo) : asset('defaults/avatar01.png')  }}" class="float-none">
                                            </td>
                                            <td class="text-center">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input changeUserStatus" id="customSwitch{{$customer->id}}" data-id="{{$customer->id}}" {{ $customer->status ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="customSwitch{{$customer->id}}"></label>
                                                </div>

                                            </td>

                                            <td class="text-center col__action__body">
                                                <a href="{{ route('customer.edit', ['id' => $customer->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                                <a href="{{ route('customer.destroy', ['id' => $customer->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection

@section('extra_js')
    <script>
        $(document).ready(function () {

            $('.changeUserStatus').change(function () {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).data('id');
                console.log(id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "{{ route('changeUserStatus') }}",
                    data: {'status': status, 'id': id},
                    success: function (data) {
                        toastr.success(data.success)
                    }
                });
            });

        })
    </script>
@endsection

