@extends('layouts.backend')
@section('title')
    Admin | edit 
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                  <h6 class="m-0 font-weight-bold text-primary">Add Testimonial</h6>
                </div>
                <div class="card-body">
                    <form role="form" method="post" action="{{ route('testimonial.update',['id'=>$item->id]) }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="name">Client Name <span class="text-danger">*</span></label>
                                <input class=" form-control" name="client_name" value="{{$item->client_name}}" placeholder="Client Name" type="text"
                                       maxlength="200" required>
                                <span class="text-danger">{{ $errors->has('client_name') ? $errors->first('client_name'):''}}</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="designation">Designation <span class="text-danger"></span></label>
                                <input class=" form-control" name="designation" value="{{$item->designation}}" placeholder="Designation" type="text"
                                       maxlength="200" >
                                <span class="text-danger">{{ $errors->has('designation') ? $errors->first('designation'):''}}</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="order">Order <span
                                        class="text-danger"></span></label>
                                <input class="form-control" type="number" min="0" name="order" value="{{$item->order}}" placeholder="Enter order (lower number has high priority)"
                                       id="position">
                                <span class="text-danger">{{ $errors->has('order') ? $errors->first('order'):''}}</span>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="comment">comment <span class="text-danger"></span></label>
                                <textarea class="form-control" rows="5" name="comment" placeholder="Comment">{!! $item->comment !!}</textarea>
                                <span class="text-danger">{{ $errors->has('comment') ? $errors->first('comment'):''}}</span>
                            </div>
                        </div>
                        <div class="form-group">
                         <label class="mb-1" for="photo">Image <span class="text-danger"></span></label>
                         <div class="custom-file">
                            <input type="file" class="custom-file-input profile-img-input" id="photo" name="image" >
                            <label class="custom-file-label" for="customFile">Choose file</label>
                         </div>
                         <span class="text-danger">{{ $errors->has('image') ? $errors->first('image'):''}}</span>
                         <div class="pt-1" id="profileLabel" for="photo">
                            <img class="profileImgShow" src="{{ $item->image ? asset('/img/testimonial/'.$item->image) : asset('defaults/default3.png')}}">
                         </div>
                        </div>
                        <button type="submit" class="float-right btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
@endsection

