@extends('layouts.backend')
@section('title')
    Admin | General settings
@endsection

@section('extra_css')
    <style>
        .show-multiple-image-preview img {
            padding: 6px;
            max-width: 100px;
        }

        .bootstrap-tagsinput .tag {
            margin-right: 2px;
            color: #260707;
        }

        input[type="number"] {
            -moz-appearance: textfield;
        }

        .select2-container .select2-selection--single {
            height: 38px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 35px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            line-height: 35px;
        }

        label {
            font-size: 16px;
            font-weight: 300;
        }
    </style>

@endsection

@section('content')
    <form role="form" method="post" action="{{ route('general_setting.update',['id'=>$g_setting->id]) }}"
          enctype="multipart/form-data">
        @csrf
        <div class="container-fluid pt-2">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">General Settings</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="company_full_name">Company Full Name</label>

                                <input type="text" name="company_full_name" maxlength="200"
                                       value="{{$g_setting->company_full_name}}" class="form-control">
                                <span class="text-danger">{{ $errors->has('company_full_name') ? $errors->first('company_full_name'):''}}</span>

                            </div>
                            <div class="form-group">
                                <label for="site_title">Site Title <span class="text-danger"></span></label>
                                <input type="text" name="site_title" value="{{$g_setting->site_title}}"
                                       class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="site_url">Site URL <span
                                            class="text-danger"></span></label>

                                <input type="text" name="site_url" value="{{$g_setting->site_url}}"
                                       class="form-control">

                            </div>
                        </div>
                    </div> <!--card-->
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">File Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group row system__logo__section">
                                <div class="col-md-4">
                                    <div class="logo">
                                        <label class="lbl" for="logo">Website Logo <small></small> <span
                                                    class="text-danger"></span></label>
                                        <input type="file" name="logo" class="getInputFile" id="validatedCustomFile"
                                               hidden/>
                                        <label class="my_file-label" for="validatedCustomFile"><i
                                                    class="fas fa-cloud-upload-alt"></i></label>
                                        <span id="my-file-chosen"></span>
                                        <span class="text-danger">{{ $errors->has('logo') ? $errors->first('logo'):''}}</span>
                                        <br>
                                        <div class="pt-1 thumb" id="profileLabel" for="photo">
                                            @if(!empty($g_setting->logo))
                                                <img class="getInputFileShow"
                                                     src="{{ asset('settings/'.$g_setting->logo) }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="favicon">
                                        <label class="lbl" for="favicon">Favicon <span
                                                    class="text-danger">(W: 100px & H: 100px)</span></label>
                                        <input type="file" name="favicon" class="getInputFilefavicon"
                                               id="validatedCustomFilefavicon" hidden/>
                                        <label class="my_file-label" for="validatedCustomFilefavicon"><i
                                                    class="fas fa-cloud-upload-alt"></i></label>
                                        <span id="my-file-chosen"></span>
                                        <span class="text-danger">{{ $errors->has('favicon') ? $errors->first('favicon'):''}}</span>
                                        <br>
                                        <div class="pt-1 thumb" id="faviconLabel" for="photo">
                                            @if(!empty($g_setting->favicon))
                                                <img class="getInputFileShow"
                                                     src="{{ asset('settings/'.$g_setting->favicon) }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="meta_image">
                                        <label class="lbl" for="favicon">Meta Image <span
                                                    class="text-danger">(W: 640px & H: 360px)</span></label>
                                        <input type="file" name="meta_image" class="getInputFileLazy"
                                               id="validatedCustomFileLazy" hidden/>
                                        <label class="my_file-label" for="validatedCustomFileLazy"><i
                                                    class="fas fa-cloud-upload-alt"></i></label>
                                        <span id="my-file-chosen"></span>
                                        <span class="text-danger">{{ $errors->has('meta_image') ? $errors->first('meta_image'):''}}</span>
                                        <br>
                                        <div class="pt-1 thumb" id="LazyLabel" for="photo">

                                            @if(!empty($g_setting->meta_image))
                                                <img class="getInputFileShow"
                                                     src="{{ asset('settings/'.$g_setting->meta_image) }}">
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!--card-->

                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Global SEO</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group ">
                                <label for="seo_title">Seo Title <span class="text-danger"></span></label>
                                <input type="text" name="seo_title" value="{{$g_setting->seo_title}}"
                                       class="form-control">
                            </div>

                            <div class="form-group ">
                                <label for="meta_title">Meta Title <span class="text-danger"></span></label>
                                <input type="text" name="meta_title" value="{{$g_setting->meta_title}}"
                                       class="form-control">
                            </div>

                            <div class="form-group ">
                                <label for="meta_description">Meta description <span class="text-danger"></span></label>
                                <textarea name="meta_description" class="form-control"
                                          rows="5"> {{$g_setting->meta_description}} </textarea>

                            </div>

                            <div class="form-group ">
                                <label for="meta_keywords">Meta Keywords <span class="text-danger"></span></label>
                                <input type="text" name="meta_keywords" value="{{$g_setting->meta_keywords}}"
                                       placeholder="Keyword, keyword" class="form-control">
                            </div>

                            <div class="form-group ">
                                <label for="meta_author">Meta Author <span class="text-danger"></span></label>
                                <input type="text" name="meta_author" value="{{$g_setting->meta_author}}"
                                       placeholder="meta author" class="form-control">
                            </div>

{{--                            <div class="form-group ">--}}
{{--                                <label for="meta_image">Meta Image</label> <br>--}}
{{--                                <input type="file" name="meta_image" class="getInputFile_meta_image"--}}
{{--                                       id="validatedCustomFile_meta_image" hidden/>--}}
{{--                                <label class="my_file-label" for="validatedCustomFile_meta_image"><i--}}
{{--                                            class="fas fa-cloud-upload-alt"></i> Upload</label>--}}
{{--                                <span id="my-file-chosen"></span>--}}
{{--                                <span class="text-danger">{{ $errors->has('meta_image') ? $errors->first('meta_image'):''}}</span>--}}
{{--                            </div>--}}

                        </div>
                    </div> <!--card-->
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Contact Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="contact_address"> Address <span class="text-danger"></span></label>
                                <input type="text" name="contact_address" value="{{$g_setting->contact_address}}"
                                       class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="contact_phone"> Phone <span class="text-danger"></span></label>
                                <input type="text" name="contact_phone" value="{{$g_setting->contact_phone}}"
                                       class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="contact_email"> Email <span class="text-danger"></span></label>
                                <input type="email" name="contact_email" value="{{$g_setting->contact_email}}"
                                       class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="map"> Google Map (<span class="text-danger">Paste Google Embed Code</span>)</label>
                                <textarea rows="6"
                                          placeholder="<iframe src=&quot;https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3652.2448873585727!2d90.4276720467015!3d2...></iframe>"
                                          class="form-control" name="map">{{$g_setting->map}}</textarea>
                            </div>
                        </div>
                    </div> <!--card-->
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Social Link</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="facebook">Facebook</label>
                                <input id="facebook" type="text" class="form-control"
                                       name="facebook" value="{{$g_setting->facebook}}"
                                       placeholder="http://facebook.com">
                            </div>
                            <div class="form-group">
                                <label for="fb_app_id">Facebook app ID</label>
                                <input id="fb_app_id" type="text" class="form-control"
                                       name="fb_app_id" value="{{$g_setting->fb_app_id}}" placeholder="FB app id">
                            </div>
                            <div class="form-group">
                                <label for="twitter">Twitter</label>
                                <input id="twitter" type="text" class="form-control" name="twitter"
                                       value="{{$g_setting->twitter}}" placeholder="http://twitter.com">
                            </div>
                            <div class="form-group">
                                <label for="instagram">Instagram</label>
                                <input id="instagram" type="text" class="form-control" name="instagram"
                                       value="{{$g_setting->instagram}}" placeholder="http://instagram.com">
                            </div>
                            <div class="form-group">
                                <label for="youtube">Youtube</label>
                                <input id="youtube" type="text" class="form-control"
                                       name="youtube" value="{{$g_setting->youtube}}" placeholder="http://youtube.com">
                            </div>
                            <div class="form-group">
                                <label for="linkedin">Linkedin</label>
                                <input id="linkedin" type="text" class="form-control"
                                       name="linkedin" value="{{$g_setting->linkedin}}"
                                       placeholder="http://linkedin.com">
                            </div>
                        </div>
                    </div><!--card-->

                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Admin Prefix Widget</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="admin_prefix">Admin Prefix</label>

                                <input type="text" name="admin_prefix" maxlength="100"
                                       value="{{$g_setting->admin_prefix}}" class="form-control">
                                <small class="text-danger">Don't use 'login' prefix</small>
                                <span class="text-danger"></span>

                            </div>
                        </div>
                    </div> <!--card-->
                    <div class="update__btn text-right">
                        <button type="submit" name="button" class="btn btn-primary mb-2">
                            Update
                        </button>
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
    </form>
@endsection