@extends('layouts.backend')
@section('title')
    Admin | Product search
@endsection

@section('extra_css')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css"/>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <style type="text/css">
        .btn-sm.btn-icon {
            padding: 8px;
            width: 35px;
            height: 35px;
        }

        .btn-circle {
            border-radius: 50em;
        }

        .btn-soft-success {
            background-color: rgba(10, 187, 117, .15);
            color: #0abb75;
        }

        .btn-soft-success:hover {
            background-color: #0abb75;
            color: #fff;
        }

        .btn-soft-primary {
            background-color: rgba(55, 125, 255, .15);
            color: #377dff;
        }

        .btn-soft-primary:hover {
            background-color: #377dff;
            color: #fff;
        }

        .btn-soft-warning {
            background-color: rgba(255, 197, 25, .15);
            color: #ffc519;
        }

        .btn-soft-warning:hover {
            background-color: #ffc519;
            color: #fff;
        }

        .btn-soft-danger {
            background-color: rgba(239, 72, 106, .15);
            color: #ef486a;
        }

        .btn-soft-danger:hover {
            background-color: #ef486a;
            color: #fff;
        }

        .product__image img {
            border-radius: 5px;
        }
    </style>


@endsection

@section('extra_js')

    <script>
        $(document).ready(function () {
            $('.auto-submit').on('change', function () {
                $('#filter-form').submit();
            });
        })

        var _token = $('input[name="_token"]').val();
        $(document).on('blur', '.column_quantity', function (){
            var column_quantity = $(this).data("column_quantity");
            var column_value = $(this).text();
            var id = $(this).data("id");
            if (column_quantity != null && $.isNumeric(column_value)) {
                $.ajax({
                    url: "{{ route('product.quantity.update') }}",
                    method: "POST",
                    data: {column_quantity: column_quantity, column_value: column_value, id: id, _token: _token},
                    success: function (data) {
                        $('#message').html(data);
                    }
                })
            } else {
                $('#message').html("<div class='alert alert-danger'>Something is wrong</div>");
            }
        });
        
        $(document).on('blur', '.column_price', function(){
          var column_price = $(this).data("column-price");
          var column_value = $(this).text();
          var id = $(this).data("id");
          var val_check = $.isNumeric(column_value);
          console.log(column_value)
          if(column_price != null && $.isNumeric(column_value))
          {
          $.ajax({
            url:"{{ route('product.price.update') }}",
            method:"POST",
            data:{column_price:column_price, unit_price:column_value, id:id, _token:_token},
            success:function(data)
            {
             $('#message').html(data);
            }
          })
          }
          else
          {
          $('#message').html("<div class='alert alert-danger'>Something is wrong</div>");
          }
        });

    </script>
@endsection



@section('content')
    <main>
        <div class="container-fluid">
            <div class="row justify-content-center">
                @include('back.parts.message')
                <div class="col-lg-6 offset-lg-3 mr-auto mt-3" id="message"></div>
                <div class="col-lg-10 m-auto">
                    <div class="card shadow-lg border-0 rounded-lg mt-3 mb-3">
                        <div class="card-header">
                            <div class="row d-flex justify-content-start">
                                <div class="col-md-2 mb-2">
                                    <a href="{{ route('product.quick.manage') }}">
                                        <h4 class=" font-weight-light my-2 float-left">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                 class="icon icon-tabler icon-tabler-arrow-back-up" width="44"
                                                 height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#ff9300"
                                                 fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                                <path d="M9 14l-4 -4l4 -4"></path>
                                                <path d="M5 10h11a4 4 0 1 1 0 8h-1"></path>
                                            </svg>
                                            Back
                                        </h4>
                                    </a>
                                </div>
                                <div class="col-md-2 mb-2">
                                    <div class="search-box">
                                        <form action="{{ route('product.quick.search')}}" role="search"
                                              class="d-flex" method="GET" style="margin: 0;">
                                            <input type="text" class="form-control"
                                                   placeholder="@if(!empty($query)){{$query}}@endif" name="search" required
                                                   style="height: 44px">
                                        </form>
                                    </div>
                                </div>
                                <div class="col-md-2 mb-2">
                                    <form id="filter-form" method="get" action="{{ route('product.quick.filter')}}">
                                        <div class="form-group">
                                            <select class="form-select form-control auto-submit" name="category_id">
                                                <option value="" selected disabled>Select Category</option>
                                                @foreach(\App\Models\Category::all() as $item)
                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Product Name</th>
                                        <th class="text-center">Stock</th>
                                        <th class="text-center">Price</th>
                                        <th class="text-center">Discount Type</th>
                                        <th class="text-center">Discount Price</th>
                                        <th class="text-center" style="width: 180px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($products as $product)
                                        <tr>
                                            <td class="text-center">{{$product->id}}</td>
                                            <td class="product__name">
                                                <a href="{{ product_url($product) }}" target="_blank">
                                                    <img src="{{ $product->feature_image ? asset('/img/product/feature/'.$product->feature_image): asset('/defaults/avatar02.png')  }}">
                                                    <p>{{ Str::limit($product->product_name, 55) }}</p>
                                                </a>
                                            </td>
                                            <td contenteditable class="column_quantity text-center"
                                                data-column_quantity="quantity"
                                                data-id="{{ $product->id }}">{{ $product->quantity }}</td>
                                            <td contenteditable data-column-price="unit_price" data-id="{{ $product->id }}" class="column_price text-center">{{ $product->unit_price }}</td>
                                            <td class="text-center">{{$product->discount_type}}</td>
                                            <td class="text-center">{{$product->discount_price}}</td>
                                            <td class="text-center col__action__body">
                                                <a title="view" target="_blank" href="{{ product_url($product) }}"
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-eye"></i></a>
                                                <a title="edit"
                                                   href="{{ route('product.quick.edit', ['id' => $product->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-edit"></i></a>
                                                <a title="delete"
                                                   href="{{ route('product.destroy', ['id' => $product->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                                {{ $products->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
