@extends('layouts.backend')
@section('title')
    Admin | Event
@endsection
@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                        <div class="col-md-6">
                            <h6 class="m-0 font-weight-bold text-primary">All Event</h6>
                        </div>
                        <div class="col-md-6">
                            <a href="{{ route('event.create') }}" class="btn btn-primary float-right">Add New</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-12">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Headline</th>
                                        <th>Start</th>
                                        <th>End</th>
                                        <th>Status</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($events as $index=>$page)
                                        @php $index++ @endphp
                                        <tr>
                                            <td>{{ $index }}</td>
                                            <td>{{ Str::limit($page->headline, 100) }}</td>
                                            <td>{{ $page->start }}</td>
                                            <td>{{ $page->end }}</td>
                                            <td>{{ $page->status?'Active':'In-Active' }}</td>
                                            <td class="col__action__body">
                                                <a title="view" target="_blank" href="{{ event_url($page) }}"
                                                   class="btn btn-success btn-sm">View</a>
                                                <a href="{{ route('event.edit', ['id' => $page->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('event.destroy', ['id' => $page->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop


