@extends('layouts.backend')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Edit Event</h5><a class="btn btn-sm btn-primary" href="{{ route('event.index') }}">All Event</a>
    </div>
    <div class="card-body">
        <div class="row justify-content-center">
            <div class="col-sm-12 col-md-10 col-lg-10">
                <form action="{{ route('event.update',$event->id) }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label for="headline">Headline</label>
                        <input type="text" name="headline" value="{{$event->headline}}" maxlength="400" class="form-control" placeholder="Enter Headline" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="start">Start</label>
                                <input type="datetime-local" name="start" value="{{$event->start}}" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="end">End</label>
                                <input type="datetime-local" name="end" value="{{$event->end}}" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="mb-1" for="content">Content</label>
                        <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                        <textarea id="description" name="content" class="form-control" rows="10" >{!! $event->content !!}</textarea>
                        <script>
                            var editor_config = {
                                path_absolute: "/",
                                selector: "#description",
                                plugins: [
                                    "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                    "searchreplace wordcount visualblocks visualchars code fullscreen",
                                    "insertdatetime media nonbreaking save table directionality",
                                    "emoticons template paste textcolor colorpicker textpattern"
                                ],
                                toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                relative_urls: false,
                                file_browser_callback: function (field_name, url, type, win) {
                                    var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                    var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                    var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                    if (type == 'image') {
                                        cmsURL = cmsURL + "&type=Images";
                                    } else {
                                        cmsURL = cmsURL + "&type=Files";
                                    }

                                    tinyMCE.activeEditor.windowManager.open({
                                        file: cmsURL,
                                        title: 'Filemanager',
                                        width: x * 0.8,
                                        height: y * 0.8,
                                        resizable: "yes",
                                        close_previous: "no"
                                    });
                                }
                            };
                            tinymce.init(editor_config);
                        </script>
                    </div>
                    

                    <div class="form-group">
                        <label for="status" class="col-form-label text-md-right">Status</label>
                        <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                            <option value="1" {{ $event->status == 1 ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ $event->status == 0 ? 'selected' : '' }}>In-Active</option>
                        </select>
                    </div>
                    <div class="form-group text-right">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="{{ route('event.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('scripts')

@endsection