@extends('layouts.frontend')
@section('css')
<style>
    
</style>
@endsection
@section('content')
<section class="sec__payment bg-secondary position-relative">
    <div class="container d-flex justify-content-center">
        <div class="row">
            <div class="col-md-6 mx-auto">
                <div class="row justify-content-center text-center pt-xl-2 pb-4 mb-1 mb-lg-3">
                    <h1 class="mb-4"><span class="text-gradient-primary">Donation</span></h1>
                    <p class="mb-0">Like what you have seen? Let’s get started. Just fill in a few details and we
                        will get in touch as soon as possible.</p>
                </div>

                <div class="card-body mb-5">
                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0 p-0">
                                @foreach($errors->all() as $error)
                                    <li class="list-group-item">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                </div>

                <form class="row needs-validation " method="POST" action="{{ route('donation') }}">
                  
                    @csrf
                    <div class="col-sm-6 mb-3">
                        <label for="fn" class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" id="fn" class="form-control @error('first_name') field-invalid @enderror" value="{{ old('first_name') }}" name="first_name" maxlength="100" required>
                        @error('first_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-sm-6 mb-3">
                        <label for="ln" class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" id="ln" class="form-control @error('last_name') field-invalid @enderror" value="{{ old('last_name') }}" name="last_name" maxlength="100" required>
                        @error('last_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" id="email" class="form-control @error('email') field-invalid @enderror" value="{{ old('email') }}" name="email" maxlength="100" required>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-3">
                            <label for="phone" class="form-label">Phone No <span class="text-danger">*</span></label>
                            <input type="text" id="phone" class="form-control @error('phone') field-invalid @enderror" value="{{ old('phone') }}" name="phone" maxlength="18" oninput="formatPhoneNum(this)" required>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-12 mb-3">
                        <label class="form-label">City</label>
                        <input type="text" class="form-control @error('city') field-invalid @enderror" value="{{ old('city') }}" name="city" maxlength="50">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12 mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" class="form-control @error('address') field-invalid @enderror" value="{{ old('address') }}" name="address" maxlength="100">
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12 mb-3">
                        <label class="form-label">Amount <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('amount') field-invalid @enderror" name="amount" min="0"  required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12 text-center pt-2 pt-md-3 pt-lg-4">
                        <button type="submit" class="btn btn-outline-primary">Donate</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection