@extends('layouts.backend')
@section('title')
Admin | profile edit
@endsection

@section('extra_css')

<style type="text/css">
  
</style>
@endsection

@section('extra_js')

@endsection

@section('content')
 
  <div class="container-fluid">
    <div class="row justify-content-center">
      @include('back.parts.message')
      <div class="col-lg-6">
        <div class="card">
          <div class="card-header"><h4 class="m-0 font-weight-bold text-center text-primary">Profile Edit</h4></div>          
          <div class="card-body">
            <form role="form" method="post" action="{{ route('user.profile.update',['id'=>$user->id]) }}" enctype="multipart/form-data">
              @csrf
              <div class="form-group">
                <label for="name">Name <span class="text-danger">*</span></label>
                  <input  class=" form-control" name="name" value="{{$user->name}}" placeholder="Name" type="text" autocomplete="off" required>
                  <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
              </div>

              <div class="form-group">
                <label for="email">Email <span class="text-danger">*</span></label>
                  <input class="form-control" type="email" name="email" value="{{$user->email}}" placeholder="Email" autocomplete="off">
                <span class="text-danger">{{ $errors->has('email') ? $errors->first('email'):''}}</span>
              </div>

              <div class="form-group">
                <label for="photo">Photo <small>(200x200)</small></label>
                <div class="custom-file">
                    <input type="file" class="custom-file-input profile-img-input"  id="photo" name="photo">
                    <label class="custom-file-label" for="customFile">Choose file</label>
                </div>
                <span class="text-danger">{{ $errors->has('photo') ? $errors->first('photo'):''}}</span>
                <div class="pt-1" id="profileLabel" for="photo">
                    <img class="profileImgShow" src="{{$user->photo? asset('/profile/'.$user->photo) : asset('defaults/avatar01.png')}}">
                </div>
            </div>

              <button type="submit" class="float-right btn btn-primary">Save</button>
            </form>
          </div>
        </div>
      </div> <!--col-5-->
    </div>  
  </div>

@endsection
