@extends('layouts.backend')
@section('title')
    Admin | SMS Report
@endsection
@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card shadow-lg border-0 rounded-lg mt-4 mb-3">
                <div class="card-body card__head">
                    <form method="POST" action="{{ route('sms-reports.search-sms') }}" class="row">
                        @csrf
                        <div class="form-group col-lg-3 col-md-4 col-sm-6">
                            <label for="">Search Type</label>
                            <select name="search_value" class="form-control search_value" required>
                                <option value="">Select Option</option>
                                <option value="today" {{$search_value=='today' ? 'selected' : ''}}>Today</option>
                                <option value="pre_month" {{$search_value=='pre_month' ? 'selected' : ''}}>Previous Month</option>
                                <option value="date_range" {{$search_value=='date_range' ? 'selected' : ''}}>Date Range</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3 col-md-4 col-sm-6 date {{ $search_value=='date_range' ? '' : 'd-none' }}">
                            <label for="">From Date</label>
                            <input type="text" name="from_date" value="{{ isset($fromDate) ? date('Y-m-d', strtotime($fromDate)) : '' }}" class="form-control date360" readonly>
                        </div>
                        
                        <div class="form-group col-lg-3 col-md-4 col-sm-6 date {{ $search_value=='date_range' ? '' : 'd-none' }}">
                            <label for="">To Date</label>
                            <input type="text" name="to_date" value="{{ isset($toDate) ? date('Y-m-d', strtotime($toDate)) : '' }}" class="form-control date360" readonly>
                        </div>
                        <div class="form-group col-lg-3 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info" style="margin-top: 32px!important;">Search</button>
                        </div>
                    </form>

                    @isset($smsList)
                <div class="table-responsive" >
                    <table class="table dataTable" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>SL</th>
                                <th>Send From</th>
                                <th>Sent To</th>
                                <th>SMS Text</th>
                                <th>Cost</th>
                                <th>Send Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $total_cost = 0;
                            @endphp
                            @foreach ($smsList as $sms)
                                @php
                                    $total_cost += $sms->sms_cost;
                                @endphp
                                <tr>
                                    <th>{{$loop->iteration}}</th>
                                    <td>{{$sms->send_from}}</td>
                                    <td>{{$sms->send_to}}</td>
                                    <td>{{urldecode(Str::limit($sms->sms_text, 50))}}</td>
                                    <td>{{$sms->sms_cost}}</td>
                                    <td>{{$sms->send_time}}</td>
                                    <td> {!! getStatusBadge($sms->status) !!} </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-info">
                                <td colspan="4">Total Cost</td>
                                <td>{{$total_cost}}</td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                @endisset
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
@endsection

@section('extra_js')
<script>
    $(document).ready(function() {
        const today = new Date();
        $('.date360').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,      
            todayHighlight: true, 
        }).datepicker('setDate', today);

        $('.search_value').change(function() {
            dateSearch($(this))
        });
        function dateSearch(_this){
            let search_value = _this.val();
            if(search_value=='date_range'){
                $('.date').removeClass('d-none');
            }else{
                $('.date').addClass('d-none');
            }
        }

    });
</script>
@endsection