@extends('layouts.backend')
@section('title')
    Admin | Product create
@endsection
@section('extra_css')

@endsection

@section('extra_js')
<script>
    $(document).ready(function () {
      //ajax category subCsategory
      $('#category_list').on('change', function (e) {
          var category_id = e.target.value;
          if (category_id) {
              $.ajax({
                  url: "{{ route('category.subcategory.ajax') }}/" + category_id,
                  type: "get",
                  dataType: "json",
                  success: function (data) {
                      $("#sub_cat_list").empty();
                      $("#sub_cat_list").append('<option selected value="">--Select Sub Category--</option>')
                      $.each(data, function (key, value) {
                          $('#sub_cat_list').append('<option value="' + value.id + '">' + value.name + '</option>')
                      })
                  }
              })
          } else {
          }
      });

    });
</script>
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
   <form role="form" method="post" action="{{ route('product.store') }}" enctype="multipart/form-data">
      {{ csrf_field() }}
      <div class="row justify-content-center">
         <div class="col-lg-8">
            <div class="card mb-4">
               <div class="card-header py-3 align-items-center justify-content-between">
                  <div class="row">
                     <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">Add Product</h6>
                     </div>
                     <div class="col-md-6 create__post text-right">
                        <a href="{{ route('product.index') }}" class="btn btn-primary">
                           View All
                        </a>
                     </div>
                  </div>
               </div>
               <div class="card-body">
                  <div class="form-group">
                     <label class="mb-1">Name <span class="text-danger">*</span></label>
                     <input name="name" placeholder="Name" type="text" maxlength="100" class="form-control" required="required">
                     <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                  </div>
                  <div class="form-group ">
                     <label class="mb-1">Description <span class="text-danger">*</span></label>
                     <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                     <textarea id="content25" name="description" class="form-control" rows="15" ></textarea>
                     <script>
                         var editor_config = {
                             path_absolute: "/",
                             selector: "#content25",
                             plugins: [
                                 "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                 "searchreplace wordcount visualblocks visualchars code fullscreen",
                                 "insertdatetime media nonbreaking save table directionality",
                                 "emoticons template paste textcolor colorpicker textpattern"
                             ],
                             toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                             relative_urls: false,
                             file_browser_callback: function (field_name, url, type, win) {
                                 var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                 var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                 var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                 if (type == 'image') {
                                     cmsURL = cmsURL + "&type=Images";
                                 } else {
                                     cmsURL = cmsURL + "&type=Files";
                                 }

                                 tinyMCE.activeEditor.windowManager.open({
                                     file: cmsURL,
                                     title: 'Filemanager',
                                     width: x * 0.8,
                                     height: y * 0.8,
                                     resizable: "yes",
                                     close_previous: "no"
                                 });
                             }
                         };
                         tinymce.init(editor_config);
                     </script>
                     <span class="text-danger">{{ $errors->has('description') ? $errors->first('description'):''}}</span>
                  </div>

               </div>
            </div>
         </div>
         <div class="col-lg-4">
            <div class="card mb-4">
               <div class="card-body">
                  <div class="form-group">
                     <label class="mb-1">Image <span class="text-danger">*</span> <span style="color: #f10000; font-weight: bold;">(width: 400px; height: 530px)</span></label>
                     <div class="custom-file">
                        <input type="file" class="custom-file-input profile-img-input" id="photo" name="feature_image" required="required">
                        <label class="custom-file-label" for="customFile">Choose file</label>
                     </div>
                     <span class="text-danger">{{ $errors->has('feature_image') ? $errors->first('feature_image'):''}}</span>
                     <div class="pt-1" id="profileLabel" for="photo">
                        <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                     </div>
                  </div>
                  
                  <div class="form-group">
                        <label for="category_id">Category <span class="text-danger">*</span></label>
                        <select class="form-control categoryselect2-single" id="category_list" name="category_id" required="required">
                        <option value="" selected="">--Select Category--</option>
                        @foreach($categories as $cat)
                        <option value="{{$cat->id}}">{{$cat->name}}</option>
                        @endforeach
                     </select>
                     <span class="text-danger">{{ $errors->has('category_id') ? $errors->first('category_id'):''}}</span>
                  </div>
                  <div class="form-group">
                    <label for="sub_cat_list"> Sub Category</label>
                    <select class="form-control" id="sub_cat_list" name="sub_category_id">
                        <option value="">--Select Sub Category--</option>
                    </select>
                </div>
                  
                  <div class="form-group">
                     <label class="mb-1">Publication Status</label>
                     <select class="form-control" name="status">
                        <option value="1">Yes</option>
                        <option value="0">No</option>
                     </select>
                  </div>
                  <div class="form-group">
                     <div class="float-right mb-3">
                        <button type="submit" class="float-right btn btn-primary">Create</button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</div>
@endsection
