@extends('layouts.backend')
@section('title')
    Admin | All Payment Information
@endsection
@section('extra_css')
    <style>
        .modal-dialog.custom {
            max-width: 60%;
        }

        .custom .table td, .table th {
            border: 1px solid #e3e6f0;
        }
        .payment__list .card.item{
            background-color: #875fc0;
            background-image: linear-gradient(315deg, #875fc0 0%, #5346ba 74%);
        }
        .payment__list .card.item .card__title{
            font-size: 17px;
            color: #fff;
            font-weight: 500;
        }
        .payment__list .card.item .h5{
            color: #ffe500;
        }
        .payment__list .event__filter .form-control {
            height: calc(1.2em + .6rem + 5px);
            padding: .2375rem .75rem;
        }

        @media (max-width: 992px) {
            .modal-dialog.custom {
                max-width: 90% !important;
                margin: 1.75rem auto;
            }
        }
    </style>
@endsection
@section('extra_js')
    <script>
        // Script to dynamically populate the modal with item details
        $(document).on('click', '.view-btn', function () {
            var itemId = $(this).data('id');
            var itemName = $(this).data('name');
            var itemPhone = $(this).data('phone');
            var itemHotel = $(this).data('hotel');
            var itemEmail = $(this).data('email');
            var itemAddress = $(this).data('address');
            var itemCity = $(this).data('city');
            var itemDate = $(this).data('date');

            var itemAmount = $(this).data('amount');
            var itemReceivedAmount = $(this).data('received_amount');
            var itemEventName = $(this).data('event_name');
            var itemOrderId = $(this).data('order_id');
            var itemMethod = $(this).data('method');
            var itemInvoice = $(this).data('invoice');
            var itemSpMessage = $(this).data('sp_message');
            var itemCurrency = $(this).data('currency');

            // Populate modal with item details in a table
            $('#itemId').text(itemId);
            $('#itemName').text(itemName);
            $('#itemPhone').text(itemPhone);
            $('#itemHotel').text(itemHotel);
            $('#itemEmail').text(itemEmail);
            $('#itemAddress').text(itemAddress);
            $('#itemCity').text(itemCity);
            $('#itemDate').text(itemDate);


            $('#itemAmount').text(itemAmount);
            $('#itemReceivedAmount').text(itemReceivedAmount);
            $('#itemEventName').text(itemEventName);
            $('#itemOrderId').text(itemOrderId);
            $('#itemMethod').text(itemMethod);
            $('#itemInvoice').text(itemInvoice);
            $('#itemSpMessage').text(itemSpMessage);
            $('#itemCurrency').text(itemCurrency);

            // Show modal
            $('#viewModal').modal('show');
        });

        document.getElementById('eventSelect').addEventListener('change', function () {
            var eventId = this.value;
            if (eventId >= 0) {
                document.getElementById('paymentFilterForm').submit();
            }
        });

    </script>
@endsection

@section('content')
    <div class="container-fluid payment__list">
        @include('back.parts.message')
        <div class="row mb-5">
            @foreach ($events as $event1)
                <div class="col-lg-3">
                    <div class="card h-100 item">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col mr-2">
                                    <div class="text-sm mb-1 card__title">{{$event1->headline}}
                                    </div>
                                    <div class="h5 mb-0 mt-3">Total Amount
                                        = Tk. {{ App\Models\PaymentInfo::where('event_id',$event1->id)->whereNotNull('amount')->sum('amount'); }}</div>

                                </div>
                                <div class="col-auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-news" width="50" height="50" viewBox="0 0 24 24" stroke-width="1" stroke="#632ccb" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M16 6h3a1 1 0 0 1 1 1v11a2 2 0 0 1 -4 0v-13a1 1 0 0 0 -1 -1h-10a1 1 0 0 0 -1 1v12a3 3 0 0 0 3 3h11"></path>
                                        <path d="M8 8l4 0"></path>
                                        <path d="M8 12l4 0"></path>
                                        <path d="M8 16l4 0"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-header py-3 align-items-center justify-content-between">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                         class="icon icon-tabler icon-tabler-brand-asana" width="22" height="22"
                                         viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                         stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <rect x="4" y="4" width="6" height="6" rx="1"/>
                                        <rect x="4" y="14" width="6" height="6" rx="1"/>
                                        <rect x="14" y="14" width="6" height="6" rx="1"/>
                                        <line x1="14" y1="7" x2="20" y2="7"/>
                                        <line x1="17" y1="4" x2="17" y2="10"/>
                                    </svg>
                                    All Payment Information
                                </h6>
                            </div>

                            <div class="col-md-3 event__filter">
                                <form action="{{ route('payment.filter') }}" method="GET" id="paymentFilterForm">
                                    <div class="form-group">
                                        <select name="event_id" class="form-control" id="eventSelect">
                                            <option value="0">All Events</option>
                                            @foreach ($events as $event)
                                                <option @if(!empty($event_id)) @if($event_id == $event->id) selected
                                                        @endif @endif value="{{$event->id}}">{{ $event->headline }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Event</th>
                                <th>Name</th>
                                <th class="text-center">Phone</th>
                                <th>Hotel</th>
                                <th class="text-center">Amount</th>
                                <th class="text-center">Getway</th>
                                <th class="col__action__body text-center">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($items as $item)
                                <tr>
                                    <td class="text-center">{{$item->id}}</td>
                                    <td>{{ $item->event?->headline }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td class="text-center">{{ $item->phone }}</td>
                                    <td>{{ $item->hotel_name }}</td>
                                    <td class="text-center">{{ $item->amount }}</td>
                                    <td class="text-center">{{ $item->method }}</td>
                                    <td class="text-center col__action__body">
                                        <a href="javascript:void(0)"
                                           class="btn btn-success btn-sm view-btn"
                                           data-id="{{ $item->shurjopay_id }}"
                                           data-name="{{ $item->name }}"
                                           data-phone="{{ $item->phone }}"
                                           data-hotel="{{ $item->hotel_name }}"
                                           data-email="{{ $item->email }}"
                                           data-address="{{ $item->address }}"
                                           data-city="{{ $item->city }}"
                                           data-date="{{ $item->date_time }}"
                                           data-amount="{{ $item->payable_amount }}"
                                           data-received_amount="{{ $item->received_amount }}"
                                           data-event_name="{{ $item->event?->headline }}"
                                           data-order_id="{{ $item->order_id }}"
                                           data-method="{{ $item->method }}"
                                           data-invoice="{{ $item->invoice_no }}"
                                           data-sp_message="{{ $item->sp_message }}"
                                           data-currency="{{ $item->currency }}"
                                        >
                                            View
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center">No payment information available</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            {{ $items->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
         aria-hidden="true">
        <div class="modal-dialog custom" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Payment Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Container for two columns -->
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th>SP ID</th>
                                    <td id="itemId"></td>
                                </tr>
                                <tr>
                                    <th>Name</th>
                                    <td id="itemName"></td>
                                </tr>
                                <tr>
                                    <th>Phone</th>
                                    <td id="itemPhone"></td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td id="itemEmail"></td>
                                </tr>
                                <tr>
                                    <th>Hotel</th>
                                    <td id="itemHotel"></td>
                                </tr>
                                <tr>
                                    <th>Address</th>
                                    <td id="itemAddress"></td>
                                </tr>
                                <tr>
                                    <th>City</th>
                                    <td id="itemCity"></td>
                                </tr>

                                <tr>
                                    <th>Date</th>
                                    <td id="itemDate"></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- Second Column -->
                        <div class="col-md-6">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <th>Payable Amount</th>
                                    <td id="itemAmount"></td>
                                </tr>
                                <tr>
                                    <th>Received Amount</th>
                                    <td id="itemReceivedAmount"></td>
                                </tr>
                                <tr>
                                    <th>Event Name</th>
                                    <td id="itemEventName"></td>
                                </tr>
                                <tr>
                                    <th>Order ID</th>
                                    <td id="itemOrderId"></td>
                                </tr>
                                <tr>
                                    <th>Getway</th>
                                    <td id="itemMethod"></td>
                                </tr>
                                <tr>
                                    <th>Invoice No</th>
                                    <td id="itemInvoice"></td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td id="itemSpMessage"></td>
                                </tr>
                                <tr>
                                    <th>Currency</th>
                                    <td id="itemCurrency"></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection