
@extends('layouts.backend')
@section('title')
    Admin | Magazine Create
@endsection
@section('extra_css')
<style type="text/css">
    
.pdf-file-label {
    overflow: hidden;
}
.custom-control-label::before, .pdf-file-label, .custom-select {
    -webkit-transition: background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;
    transition: background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;
    transition: background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    transition: background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;
}
.pdf-file-label {
    position: absolute;
    top: 0;
    right: 0;
    left: 0;
    z-index: 1;
    height: calc(1.5em + 0.75rem + 2px);
    padding: 0.375rem 0.75rem;
    font-weight: 400;
    line-height: 1.5;
    color: #6e707e;
    background-color: #fff;
    border: 1px solid #d1d3e2;
    border-radius: 0.25rem;
    -webkit-box-shadow: 0 .125rem .25rem 0 rgba(58,59,69,.2)!important;
    box-shadow: 0 .125rem .25rem 0 rgba(58,59,69,.2)!important;
}
.pdf-file-input:lang(en)~.pdf-file-label::after {
    content: "Browse";
    color: #fff;
    background-color: #6777ef;
    border-color: #6777ef;
}
.pdf-file-label::after {
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    z-index: 3;
    display: block;
    height: calc(1.5em + 0.75rem);
    padding: 0.375rem 0.75rem;
    line-height: 1.5;
    color: #6e707e;
    content: "Browse";
    background-color: #eaecf4;
    border-left: inherit;
    border-radius: 0 0.35rem 0.35rem 0;
}
</style>
   
@endsection

@section('extra_js')
<script>
    //image preview
        $('.pdf-input').change(function (e) {
            var reader = new FileReader();
            $('.pdf-file-name').html(e.target.files[0].name);
            // reader.onload = function (e) {
            //     $('.profileImgShow').attr('src', e.target.result);
            // }
            // reader.readAsDataURL(e.target.files['0']);
        })
</script>
@endsection
@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Add Magazine</h6>
                </div>
                <div class="card-body">
                    <form role="form" method="post" action="{{ route('magazine.store') }}" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label for="intro">Intro</label>
                            <textarea class="form-control" id="intro" name="intro" maxlenght="250" required="required" rows="6"></textarea>
                            <span class="text-danger">{{ $errors->has('intro') ? $errors->first('intro'):''}}</span>
                        </div>
                        <div class="form-group">
                            <label class="mb-1">PDF</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input pdf-input" id="pdf" name="pdf">
                                <label class="pdf-file-label pdf-file-name" for="customFile">Choose file</label>
                            </div>
                            <span class="text-danger">{{ $errors->has('pdf') ? $errors->first('pdf'):''}}</span>
                        </div>

                        <div class="form-group">
                            <label class="mb-1">Image</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input profile-img-input" id="photo" name="image">
                                <label class="custom-file-label" for="customFile">Choose file</label>
                            </div>
                            <span class="text-danger">{{ $errors->has('image') ? $errors->first('image'):''}}</span>
                            <div class="pt-1" id="profileLabel" for="photo">
                                <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                            </div>
                        </div>
                        <div class="form-group float-right mt-2 mb-0">
                            <button type="submit" class="btn btn-success submit">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </div> <!--col-6-->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">All Magazine</h6>
                </div>
                <div class="table-responsive">
                    <table class="table align-items-center table-flush">
                        <thead class="thead-light">
                            <tr>
                                <tr>
                                    <th class="text-center col__id">ID</th>
                                    <th>Intro</th>
                                    <th class="text-center col__pos">Position</th>
                                    <th class="text-center" style="width: 150px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $items = \App\Models\Magazine::orderBy('id','desc')->Paginate(30); ?>
                                @foreach($items as $row)
                                <tr>
                                    <td class="text-center">{{$row->id}}</td>
                                    <td>
                                        {{$row->intro}}
                                    </td>
                                    <td class="text-center">
                                        <img class="feature_image" src="{{asset('/img/magazine/'.$row->image)}}">
                                    </td>
                                    <td class="text-center col__action__body">
                                        <a title="view" target="_blank" href="{{'/pdf/'.$row->pdf}}" class="btn btn-soft-success btn-icon btn-circle btn-sm"><i class="fa fa-eye"></i></a>
                                        <a href="{{ route('magazine.edit', ['id' => $row->id])}}" class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i class="fa fa-edit"></i></a>
                                        <a href="{{ route('magazine.destroy', ['id' => $row->id])}}" onclick="return confirm('Are you sure to delete this!')" class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="pagination px-3 pb-2">
                            {{$items->links()}}
                        </div>
                    </div>
                </div>
            </div> <!--col-6-->
        </div>
    </div>
@endsection


