<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\User;
use App\Models\Tag;
use App\Models\SubCategory;
use App\Models\Category;

class Post extends Model
{
    use HasFactory;

    protected $fillable = ['id','user_id', 'headline', 'slug', 'content', 'image', 'status'];
    protected $table = 'posts';
    public function category()
    {
        return $this->belongsToMany(Category::class);
    }
    public function subCategory()
    {
        return $this->belongsToMany(SubCategory::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function tag()
    {
        return $this->belongsToMany(Tag::class);
    }
}
