<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Jobs\SendSmsJob;
use App\Models\SmsRecord;
use App\Services\Sms\SmsService;
use Illuminate\Http\Request;

class SmsController extends Controller
{
    public function generalSmsList()
    {
        $generalSmsList = SmsRecord::where('type', 'general')->get();
        return view('back.sms.general_sms_index', compact('generalSmsList'));
    }

    public function generalSmsCreate()
    {
        return view('back.sms.general_sms_create');
    }

    public function generalSmsSend(Request $request)
    {
        $validatedData = $request->validate([
            'mobile_number' => 'required',
            'sms_body' => 'required',
        ]);
        // dd($request);
        $mobileNumbers = array_map('trim', explode(',', $validatedData['mobile_number']));

        $smsBody = $validatedData['sms_body'];

        $successCount = 0;
        $failCount = 0;
        $invalidNumbers = [];
        //chunking the mobile numbers
        $chunkedNumbers = array_chunk($mobileNumbers, 100);
        foreach ($chunkedNumbers as $chunk) {
            foreach ($chunk as $number) {
                if (isValidBangladeshiNumber($number)) {

                    SendSmsJob::dispatch($number, $smsBody, 'general');
                    $successCount++;
                } else {
                    $invalidNumbers[] = $number;
                    $failCount++;
                }
            }
        }


        return redirect()->route('general-sms.list')->with(
            'success', "$successCount SMS successfully send. " . " <span style='background: yellow; color: red;'>$failCount SMS failed to send. " . implode(',', $invalidNumbers) . " invalid number(s) found.</span>",
        );
    }

    public function smsReports()
    {
        $search_value = '';
        $smsList = [];
        return view('back.sms.report', compact('search_value', 'smsList'));
    }

    public function searchSmsData(Request $request)
    {
        // Start building the query
        $smsList = [];
        $search_value = $request->search_value;

        // dd($smsList);
        if ($search_value == 'pre_month') {
            // Create DateTime object for the first day of the previous month
            $firstDayPreviousMonth = new \DateTime('first day of last month');

            // Create DateTime object for the last day of the previous month
            $lastDayPreviousMonth = new \DateTime('last day of last month');

            // Format the dates as needed (e.g., 'Y-m-d' for '2023-06-30')
            $fromDate = $firstDayPreviousMonth->format('Y-m-d 00:00:00');
            $toDate = $lastDayPreviousMonth->format('Y-m-d 23:59:59');
        } elseif ($search_value == 'date_range') {
            // Use the dates provided in the request
            $fromDate = $request->from_date . ' 00:00:00';
            $toDate = $request->to_date . ' 23:59:59';
        } elseif ($search_value == 'today') {
            // Use today's date
            $fromDate = date('Y-m-d 00:00:00');
            $toDate = date('Y-m-d 23:59:59');
        }

        // Add the date range condition to the query
        if (isset($fromDate) && isset($toDate)) {
            $smsList = SmsRecord::whereBetween('send_time', [$fromDate, $toDate]);
        }

        // Get the filtered results
        $smsList = $smsList->get();

        // Return the view with the filtered results
        return view('back.sms.report', compact('smsList', 'fromDate', 'toDate', 'search_value'));
    }
    

    
}
