<?php

namespace App\Http\Controllers;

use App\Models\Color;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Tag;
use App\Models\Product;
use DateTime;
use Auth;
use Image;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator; 
class ProductController extends Controller
{
    public function categorySubCategoryAJAX($category_id){
        $sub_category  = SubCategory::where('category_id',$category_id)->get();
        return Response::json($sub_category);
    }

    public function index()
    {
        $products = Product::orderby('id', 'desc')->paginate(20);
        return view('back.product.product_index', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::orderby('position','asc')->get();
        return view('back.product.product_create', compact( 'categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'category_id' => 'required',
            'description' => 'required',
            'feature_image' => 'required',
        ]);
        $product =  new Product();
        $product->status    = $request->status?$request->status:0;
        $product->user_id               = Auth::user()->id;
        $product->category_id           = $request->category_id;
        $product->sub_category_id           = $request->sub_category_id;
        $product->name          = $request->name;
        $product->slug                  = $request->slug ?make_slug($request->slug) : make_slug($request->name);
        $product->description          = $request->description;
        
        $date_time = date('YmdHis');
        if($request->hasfile('feature_image')){
            $file = $request->file('feature_image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = make_slug($fileOrgName).'-'.$date_time.'.'.$fileExt;
            // $image_resize = Image::make($file->getRealPath());       
            // $image_resize->resize(500, 300);
            // $image_resize->save(public_path('' .$fileName));
            $file->move(public_path('/img/product/feature/'), $fileName);
            $product->feature_image = $fileName;
        }
     
        $product->save();
        return Redirect()->back()->with('success',  'Product inserted successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product = Product::find($id);
        $categories = Category::orderby('position','asc')->get();
        return view('back.product.product_edit', compact('product','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $product =  Product::find($id);
        $request->validate([
            'name' => 'required',
            'category_id' => 'required',
            'description' => 'required',
        ]);
        $product =  Product::find($id);
        $product->status    = $request->status?$request->status:0;
        $product->user_id               = Auth::user()->id;
        $product->category_id           = $request->category_id;
        $product->sub_category_id           = $request->sub_category_id;
        $product->name          = $request->name;
        $product->slug                  = $request->slug ?make_slug($request->slug) : make_slug($request->name);
        $product->description          = $request->description;
        
        $date_time = date('YmdHis');
        if($request->hasfile('feature_image')){
            $file = $request->file('feature_image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileName = make_slug($fileOrgName).'-'.$date_time.'.'.$fileExt;
            // $image_resize = Image::make($file->getRealPath());       
            // $image_resize->resize(500, 300);
            // $image_resize->save(public_path('' .$fileName));
            $file->move(public_path('/img/product/feature/'), $fileName);
            $product->feature_image = $fileName;
        }
        $product->save();
        return Redirect()->route('product.index')->with('success',  'Product update successfully');
    }

    public function duplicate($id){
        $product = Product::findOrFail($id);
        $rand_code = rand(111,999);
        $newProduct = $product->replicate();
        $newProduct->name = $product->name.' '.$rand_code;
        $newProduct->slug = $product->slug.'-'.$rand_code;
        $newProduct->category_id  = $product->category_id;
        $newProduct->created_at = Carbon::now();
        $newProduct->save();
        return Redirect()->route('product.index')->with('success',  'Product duplicate successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $product =  Product::find($id);
        $product->delete();
        return Redirect()->back()->with('success',  'Product deleted successfully');
    }

    

    // AJAX
    public function parentCategoryCategoryAJAX($p_category_id){
        $category  = Category::where('parent_category_id',$p_category_id)->get();
        return Response::json($category);
    }

    public function categorySubCategoyAJAX($category_id){
        $sub_category  = SubCategory::where('category_id',$category_id)->get();
        return Response::json($sub_category);
    }

    // changeTodaysDeal toggle
    public function changeTodaysDeal(Request $request)
    {
        $product = Product::find($request->id);
        $product->todays_Deal = $request->todays_Deal;
        $product->save();
  
        return response()->json(['success'=>'Todays Deal change successfully.']);
    }

    public function changePublicationStatus(Request $request){
        $product = Product::find($request->id);
        $product->publication_status = $request->publication_status;
        $product->save();
        return response()->json(['success'=>'Publication status change successfully.']);
    }

    public function changeFeaturedStatus(Request $request){
        $product = Product::find($request->id);
        $product->feature = $request->feature;
        $product->save();
        return response()->json(['success'=>'Feature status change successfully.']);
    }

 
    public function productSearch(Request $request){
        $query = $request->search;
        $product = Product::where('id', $query)->first();
        if(!empty($product)){
            $products = Product::where('id', $query)->paginate(20);
        }else{
            $products = Product::where('product_name', 'LIKE', '%' . $query . '%')
                ->orWhere('id', 'LIKE' . $query)
                ->paginate(20);
        }
        $products->appends($request->all());
        return view('back.product.product_search', compact('products','query'));
    }
    
  
    
    
    
 
  
    
    
}



