<?php

namespace App\Http\Controllers;

use App\Models\Magazine;
use Illuminate\Http\Request;
use Image;
use File;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Pagination\CursorPaginator;

class MagazineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('back.magazine.create');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('back.magazine.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'intro' => 'required|max:250',
        ]);
        $date_time = date('YmdHis');
        $magazine = new Magazine();
        $magazine->intro = $request->intro;
        if($request->hasfile('pdf')){
            $file = $request->file('pdf');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileOrgName2 = make_slug($fileOrgName);
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/pdf'), $fileName);
            $magazine->pdf = $fileName;
        }

        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileOrgName2 = make_slug($fileOrgName);
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/img/magazine/'), $fileName);
            $magazine->image = $fileName;
        }
        $magazine->save();
        return Redirect()->back()->with('success',  'successfully inserted');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Magazine  $magazine
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $edit = Magazine::findOrfail($id);
        return view('back.magazine.edit', compact('edit'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Magazine  $magazine
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $magazine = Magazine::findOrfail($id);
        $request->validate([
            'intro' => 'required|max:250',
        ]);
        $date_time = date('YmdHis');
        $magazine->intro = $request->intro;

        if($request->hasfile('pdf')){
            $file = $request->file('pdf');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileOrgName2 = make_slug($fileOrgName);
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/pdf'), $fileName);
            $magazine->pdf = $fileName;
        }
        
        if($request->hasfile('image')){
            $file = $request->file('image');
            $fileName = $file->getClientOriginalName();
            $fileExt = $file->getClientOriginalExtension();
            $fileOrgName = basename($fileName,".".$fileExt);
            $fileOrgName2 = make_slug($fileOrgName);
            $fileName = $date_time.'.'.$fileExt;
            $file->move(public_path('/img/magazine/'), $fileName);
            $magazine->image = $fileName;
        }
        $magazine->save();
        return Redirect()->route('magazine.index')->with('success',  'successfully updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Magazine  $magazine
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $magazine = Magazine::find($id);
        // dd($magazine );
        if(File::exists(public_path('/img/magazine/'.$magazine->image))){
            File::delete(public_path('/img/magazine/'.$magazine->image));
        }
        $magazine->delete();
        Session::flash('success', 'successfully deleted');
        return Redirect()->route('magazine.index');
    }
}
